//
//  APPlayer.m
//  APlayer
//
//  Created by Holger Sadewasser on 4/20/08.
//  Copyright 2008. All rights reserved.
//

#import <unistd.h>
#import "APPlayer.h"
#import "APTarget.h"
#import "APTargetList.h"
#import "APKeystroke.h"
#import "tools.h"


extern BOOL gFlgLogging;

//int gNumOfTargets = 0;


// methods that are used internally by this class, but should not be needed externally
// are defined here to keep them "private". Anyone who knows about them can still call
// them of course, but by putting the prototypes here, it emphasizes that they are only
// meant for internal use.
@interface APPlayer(_private_methods)

-(double)_distanceFromShip:(APShip *)iShip toNextObjectIn:(NSArray *)iObjects;
-(int)_rotationToWaitPosition;

@end


@implementation APPlayer

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)initWithIOChannel:(APIOChannel *)iIOChannel maxFrames:(unsigned int)iMaxFrames {
  self = [super init];
  if (self != nil) {
    mIOChannel = iIOChannel;
    [mIOChannel retain];
    [mIOChannel setDataCallbackObject:self];
    mTracker = [[APTracker alloc] initWithIOChannel:iIOChannel];
    mProphet = [[APProphet alloc] init];
    mKeySequence = [[NSMutableArray alloc] initWithCapacity:100];
    mTargets = [[NSMutableArray alloc] initWithCapacity:40];
    mMaxFrames = iMaxFrames;
    mFlgSaucerConsidered = NO;
    mFlgWaiting = NO;
  }
  return self;
}


-(void)dealloc {
  [mTargets release];
  [mKeySequence release];
  [mProphet release];
  [mTracker release];
  [mIOChannel setDataCallbackObject:nil];
  [mIOChannel release];
  [super dealloc];
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)playInThread {
  
  NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
  uint8_t keys;
  
  NSLog( @"Player thread started\n" );
  
  //  keys |= 0x10;
  for (;;) {
    keys ^= 2;
//    [mIOChannel sendKeys:keys];
    usleep(1000000);
  }
  
  [pool release];
}


-(void)dataReceived:(NSData *)iPacket {
  
  static uint8_t last_keys = 0;
  uint8_t keys = 0;
  NSArray * objects = [mTracker interpretScreen:iPacket];
  NSMutableArray * listOfHits = nil;
  APTarget * target;
  APTarget * saucerTarget = nil;
  APKeystroke * keystroke;
  int repeat;
  int size;
  APObjectTypes_t type;
  int count, i;
  int rotation;
  
  if ( [mTracker lostFrames] > 10 ) {
    NSLog(@"player: snapshots: %d", [mTracker->mSnapshots count]);
    NSLog(@"player: objects: %d", [[mTracker->mSnapshots objectAtIndex:0] count]);
    if ( [NSKeyedArchiver archiveRootObject:mTracker->mSnapshots toFile:@"/Users/holger/MAME/snapshots"] == YES )
      NSLog(@"Snaptshots successfully archived");
    else
      NSLog(@"Snaptshots not archived");
    [mIOChannel close];
    return;
  }

  if ( [mTracker shipPresent] == NO || ([mTracker numberOfAsteroids] == 0 && [mTracker saucerPresent] == NO) ) {
    if ( mFlgWaiting == NO ) {
      if ( [mTracker shipPresent] == YES ) {
        [mKeySequence removeAllObjects];
        rotation = [self _rotationToWaitPosition];
        if ( rotation != 0 ) {
          if ( rotation >= 0 ) {
            keys = cKeyLeft;
            repeat = rotation;
          } else if ( rotation < 0 ) {
            keys = cKeyRight;
            repeat = -rotation;
          }
          keystroke = [APKeystroke keystrokeWithKeys:keys repeat:repeat target:nil];
          [mKeySequence addObject:keystroke];
        }
        keystroke = [APKeystroke keystrokeWithKeys:cKeyNone repeat:2 target:nil];
        [mKeySequence addObject:keystroke];
      } else if ( last_keys != cKeyNone ) {
        // make sure we release all keys if there is no ship or no objects on the screen
        last_keys = cKeyNone;
        [mKeySequence removeAllObjects];
        keystroke = [APKeystroke keystrokeWithKeys:0xe0 repeat:2 target:nil];
        [mKeySequence addObject:keystroke];
      }
      mFlgWaiting = YES;
    }
  } else {
    
    if ( mFlgWaiting == YES ) {
      [mKeySequence removeAllObjects];
      mFlgWaiting = NO;      
    }
    
    if ( [self _distanceFromShip:[mTracker ship] toNextObjectIn:objects] <= 0.0 ) {
      
      [mKeySequence removeAllObjects];
      keystroke = [APKeystroke keystrokeWithKeys:cKeyHyperspace repeat:1 target:nil];
      [mKeySequence addObject:keystroke];      
      
    } else {
      if ( [mTracker saucerPresent] == YES && ([mKeySequence count] == 0 || mFlgSaucerConsidered == NO) ) {
        listOfHits = [mProphet hitsFor:mTracker];
        count = [listOfHits count];
        for ( i = 0; i < count; i++ ) {
          target = [listOfHits objectAtIndex:i];
          if ( [[target object] type] == cSaucer ) {
            saucerTarget = target;
            if ( [mKeySequence count] > 0 ) {
            }
          }
        }
      }
      if ( [mKeySequence count] > 0 ) {
        // Check if the current target still exists. If not remove all keystrokes and
        // select the next target
        keystroke = [mKeySequence objectAtIndex:0];
        if ( [objects containsObject:[[keystroke target] object]] == NO ) {
          [mKeySequence removeAllObjects];
          NSLog(@"key sequence removed");
        }
      }
      if ( [mKeySequence count] == 0 ) {

        if ( listOfHits == nil )
          listOfHits = [mProphet hitsFor:mTracker];
        if ( [listOfHits count] > 0 ) {
          [listOfHits sortUsingSelector:@selector(compareToTarget:)];
          target = [listOfHits objectAtIndex:0];
          size = [[target object] size];
          type = [[target object] type];
          
          if ( gFlgLogging == YES )
            NSLog(@"ta: %d  fs: %d  rd: %d  tts: %f  dos: %f", target->mAngleByte, target->mFrameOfShot, target->mRotDirection, target->mTotalDuration, target->mDurationOfShot);
          
          if ( target->mFrameOfShot > 0 ) {
            if ( target->mRotDirection > 0 )
              keys |= cKeyLeft;
            else if ( target->mRotDirection < 0 )
              keys |= cKeyRight;
            
            if ( saucerTarget != nil && saucerTarget->mRotDirection == target->mRotDirection && saucerTarget->mFrameOfShot < target->mFrameOfShot-1 ) {
              [mKeySequence addObject:[APKeystroke keystrokeWithKeys:keys repeat:saucerTarget->mFrameOfShot target:saucerTarget]];
              keys |= cKeyFire;
              [mKeySequence addObject:[APKeystroke keystrokeWithKeys:keys repeat:1 target:saucerTarget]];
              keys &= ~cKeyFire;
              [mKeySequence addObject:[APKeystroke keystrokeWithKeys:keys repeat:1 target:saucerTarget]];
              repeat = target->mFrameOfShot - saucerTarget->mFrameOfShot - 2;
              mFlgSaucerConsidered = YES;
            } else {
              repeat = target->mFrameOfShot;
            }
            if ( repeat > 0 ) {
              [mKeySequence addObject:[APKeystroke keystrokeWithKeys:keys repeat:repeat target:target]];
            }
          }
          if ( type == cAsteroid1 || type == cAsteroid2 || type == cAsteroid3 || type == cAsteroid4 ) {
            switch ( size ) {
              case 0:
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                break;
              case 15:
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                break;
              default:
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
                [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
                break;
            }
          } else {
            [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyFire repeat:1 target:target]];
            [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:target]];
          }
        } else {
          if ( last_keys != cKeyNone ) {
            // make sure we release all keys if there is nothing else to do
            last_keys = cKeyNone;
            [mKeySequence addObject:[APKeystroke keystrokeWithKeys:cKeyNone repeat:1 target:nil]];
          }
        }
      }
    }
  }
  
  if ( [mKeySequence count] > 0 ) {
    // The first object in the sequence is the next key stroke
    keystroke = [mKeySequence objectAtIndex:0];
    
    // Set the time to live if we shoot at a target
//    if ( (last_keys & cKeyFire) && !([keystroke keys] & cKeyFire) ) {
//      if ( last_target != nil && [[last_target object] timeToLive] < 0 )
//        [[last_target object] setTimeToLive:(int)([last_target durationOfShot] + 1.5)];
//    }
    
    last_keys = [keystroke keys];
    target = [keystroke target];
    if ( (last_keys & cKeyFire) && target != nil && [[target object] timeToLive] < 0 ) {
      [[target object] setTimeToLive:(int)([target durationOfShot] + 2.5)];
    }
    
    // Send the keys
    [mIOChannel sendKeys:last_keys];
    
    // Decrease repeat counter and remove key stroke from sequence if this was the last stroke
    [keystroke sent];
    if ( [keystroke repeatCount] == 0 ) {
      [mKeySequence removeObjectAtIndex:0];
      if ( [mKeySequence count] == 0 )
        mFlgSaucerConsidered = NO;
    }
  }

//- Begin Records shot angles ---------------------
//  uint8_t keys = 0;
//  static int count = 0;
//  static int shotCount = 0;
//  static int state = 0;
//  
//  if ( ++count >= 5 ) {
//    if ( mTracker->mFlgShipPresent == YES ) {
////         ((APTracker *)mDataCallbackObject)->mFlgSaucerPresent == NO ) {
//      switch (state) {
//        case 0:
//          if ( mTracker->mNumShots < 4 ) {
//            keys |= 2;
//            state = 1;
//            shotCount = 0;
//          }
//          break;
//        case 1:
//          keys &= ~2;
//          if ( ++shotCount >= 10 ) {
//            keys |= 0x10;
//            state = 0;
//          }
//            break;
//      }
//      }
//  }
//  [mIOChannel sendKeys:keys];
//- End Records shot angles ---------------------    

}


- (void)timerFired:(NSTimer *)iTimer {

  static uint8_t keys = '@';
  
  //  keys |= 0x10;
  keys ^= 2;
//  [mIOChannel sendKeys:keys];
  
}


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Private Methods
// -------------------------------------------------------------------------------------

-(double)_distanceFromShip:(APShip *)iShip toNextObjectIn:(NSArray *)iObjects {
 
  APObject * object;
//  APObject * nextObject;
  int count = [iObjects count];
  int i;
  double distX, distY, dist, minDist;
  
  minDist = 1e10;
  for ( i = 0; i < count; ++i ) {
    object = [iObjects objectAtIndex:i];
    if ( [object type] != cShip && object->mFlgHyperspace == YES ) {
      distX = distXdouble( object->mPosX, iShip->mPosX );
      distY = distYdouble( object->mPosY, iShip->mPosY );      
      dist = distX*distX + distY*distY - object->mRadius2 - iShip->mRadius2;
      if ( dist < minDist ) {
        minDist = dist;
//        nextObject = object;
      }
    }
  }
//  if ( minDist <= 0.0 && nextObject != nil ) {
//    for ( i = 0; i < count; ++i ) {
//      object = [iObjects objectAtIndex:i];
//      NSLog(@"type: %d  x: %f  y: %f  frames: %d  hit: %d", [object type], [object posX], [object posY], [object frames], (object == nextObject));
//    }
//  }
  return minDist;
}

-(int)_rotationToWaitPosition {

  APShip * ship = [mTracker ship];
  double x, y, newAngle, curAngle, dAngle;
  int rotation;
  
  x = [ship posX] - 512.0;
  y = [ship posY] - 384.0;
  newAngle = acos(x / sqrt(x*x + y*y));
  if ( y < 0.0 ) newAngle = 2.0*M_PI - newAngle;
  curAngle = (double)[ship angleByte] * 3.0 * M_PI / 128.0;
  while( curAngle >= 2.0*M_PI ) curAngle -= 2.0 * M_PI;
  dAngle = newAngle - curAngle;
  if ( dAngle > M_PI) {
    dAngle -= 2.0 * M_PI;
  } else if ( dAngle < -M_PI ) {
    dAngle += 2.0 * M_PI;
  }
  
  rotation = (int)(dAngle / (3.0 * M_PI / 128.0) + 0.5);
  
  NSLog(@"x: %f  y: %f  na: %f  ca: %f  da: %f  rot: %d", x, y, newAngle, curAngle, dAngle, rotation);
  return rotation;
}

@end
